import random
import Const
import pickle

"""人用クラス
"""
class PlayerHuman:    
    def play(self,kiban,qtable,greedy):
        flg = False
        while True:
            y = input('X:')
            if not y:
                print("何か打ってよー")
                continue

            if y[0] == 'p':     #状態を入力すると対応するQ値表示 入力例)p100000000
                if y[1:] not in qtable.table.keys():
                    print("キーがありません")                
                else: 
                    print(qtable.get(y[1:]))                
                continue
            elif y[0] == 'd':   #棋盤表示
                kiban.disp()
                continue
            elif y[0] == 'b':   #強制終了
                flg = True
                break
            elif y[0] == 'a':   #全ての状態:Q値を表示
                qtable.disp()
                continue
            elif y[0] == 'c':   #Qテーブルサイズ
                print(len(qtable.table))
                continue
            elif y[0] == 's':   #Qテーブルサイズ
                self.pickle_dump(qtable.table, './dict33.pickle')
                continue
            elif y[0] == 'l':   #Qテーブルサイズ
                qtable.table = self.pickle_load('./dict33.pickle')
                continue
            x = input('Y:')
            if not x.isnumeric()  or  not y.isnumeric():
                print("数字ではありません")
                continue
            x2 = int(x)
            y2 = int(y)
            if( x2 >= Const.BANSU or y2 >= Const.BANSU):
                print("盤がありません。")
            elif kiban.checkKiban(x2,y2) == False:
                print("既に打たれています")
                continue
            else:
                break
        
        if flg == True:
            return []
        else:
            return [x2,y2]

    def pickle_dump(self,obj, path):
        with open(path, mode='wb') as f:
            pickle.dump(obj,f)

    def pickle_load(self,path):
        with open(path, mode='rb') as f:
            return pickle.load(f)
    def whois(self):
        return Const.HUMAN
